<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    PrestaHeroes <info@prestaheroes.com>
*  @copyright 2016 Heroic Business Solutions LLC
*  @license   commercial
*/

class Address extends AddressCore
{
    protected static $idCountries = array();
    public static function getCountryAndState($id_address)
    {
        if (isset(self::$idCountries[$id_address])) {
            return self::$idCountries[$id_address];
        }
        if ($id_address) {
            $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
            SELECT `id_country`, `id_state`, `vat_number`, `postcode` FROM `'._DB_PREFIX_.'address`
            WHERE `id_address` = '.(int)$id_address);
        } else {
            $result = false;
        }
        if (Module::isEnabled('geotargetingpro')) {
            if (isset(Context::getContext()->cookie->iso_code_country) &&
                (bool)Configuration::get('GTP_ADDRESS_OVERRIDE')
            ) {
                $result['id_country'] = Country::getByIso(Context::getContext()->cookie->iso_code_country);
            }
        }
        self::$idCountries[$id_address] = $result;
        return $result;
    }
}
